/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.stream.impl;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.param.PushMessageBucket;
import com.bxm.localnews.msg.stream.MessageProcessor;
import com.bxm.localnews.msg.stream.MessageProvider;
import javax.annotation.Resource;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.MessageChannel;

@EnableBinding(value={MessageProcessor.class})
public class MessageProviderImpl
implements MessageProvider {
    @Resource
    private MessageChannel singlePushOutput;
    @Resource
    private MessageChannel batchPushOutput;
    @Resource
    private MessageChannel userEventOutput;

    @Override
    public void singlePush(PushMessage message) {
        this.singlePushOutput.send(MessageBuilder.withPayload((Object)message).build());
    }

    @Override
    public void batchPush(PushMessageBucket bucket) {
        this.batchPushOutput.send(MessageBuilder.withPayload((Object)bucket).build());
    }

    @Override
    public void userEvent(Long userId) {
        this.userEventOutput.send(MessageBuilder.withPayload((Object)userId).build());
    }
}

