package com.bxm.localnews.msg.config;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 本地圈互动消息配置
 *
 * @author wzy
 * @version 1.0
 * @date 2020/9/21 8:04 下午
 */
@Component
@ConfigurationProperties("message.config.interact")
@Data
@Slf4j
public class InteractMessageProperties {
    /**
     * 是否开启本地圈互动消息
     */
    private Boolean open = true;

    /**
     * 出现一些缓存未同步的情况设置默认头像
     */
    private String defaultHeadImg = "https://m.wstong.com/localnews_prod/jpg/20190918/1V966V81QM19PPLQW00Y02C939932UWOVXO0KE3.jpg?x-oss-process=style/scompress";
}