package com.bxm.localnews.msg.dingtalk.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.config.DingtalkProperties;
import com.bxm.localnews.msg.dingtalk.DingtalkPushService;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import static org.apache.commons.lang.StringUtils.isBlank;

@Service
@RefreshScope
public class DingtalkPushServiceImpl extends BaseService implements DingtalkPushService {

    private final DingtalkProperties dingtalkProperties;

    private final HttpClientService httpClientService;

    @Autowired
    public DingtalkPushServiceImpl(DingtalkProperties dingtalkProperties,
                                   HttpClientService httpClientService) {
        this.dingtalkProperties = dingtalkProperties;
        this.httpClientService = httpClientService;
    }

    @Override
    public void pushNews(String content) {
        push(DingtalkMessage.builder().scene("news").content(content).build());
    }

    @Override
    public void pushIM(String content) {
        push(DingtalkMessage.builder().scene("im").content(content).build());
    }

    @Override
    public void push(DingtalkMessage message) {
        String webHookUrl = dingtalkProperties.getSceneMap().get(message.getScene());

        if (isBlank(webHookUrl)) {
            logger.info("推送场景不存在，将消息推送到运维监控群");

            webHookUrl = dingtalkProperties.getSceneMap().get(dingtalkProperties.getDefaultScene());
        }

        JSONObject text = new JSONObject();
        text.put("content", message.getContent());

        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);

        String response = httpClientService.doPostJson(webHookUrl, msg.toJSONString());

        if (logger.isDebugEnabled()) {
            logger.debug("push content:[{}],response:[{}]", JSON.toJSONString(message), response);
        }
    }
}
