package com.bxm.localnews.msg.service.filter;

import com.bxm.localnews.mq.common.model.dto.MessageFilterInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author pf.w
 * @date 2020/11/26 17:43
 **/
@Component
public class FilterSaveStrategyManage {

    private final List<MessageFilterSaveStrategy> strategyList;

    @Autowired
    public FilterSaveStrategyManage(List<MessageFilterSaveStrategy> strategyList){
     this.strategyList = strategyList;
    }

    /**
     * 策略模式 不同类型 不同存储模式
     * @param info
     */
    public void excute(MessageFilterInfo info){
        for (MessageFilterSaveStrategy messageFilterSaveStrategy : strategyList) {
            if(messageFilterSaveStrategy.match(info)){
                messageFilterSaveStrategy.saveLogic(info);
            }
        }
    }
}
