package com.bxm.localnews.msg.service.filter;

import com.bxm.localnews.mq.common.model.dto.MessageFilterInfo;

/**
 * @author pf.w
 * @date 2020/11/26 17:35
 **/
public interface MessageFilterSaveStrategy {

    /**
     * 保存逻辑
     *
     * 目前 召回信息以hashMap形式存储在缓存 key-消息类型  value-对应的数据格式   不同类型数据格式可以不同
     *
     * 不同的类型可以保存不同的数据形式  value值可存储不同的格式，方便扩展和区别对待
     *
     * @param info
     */
    void saveLogic(MessageFilterInfo info);

    /**
     * 策略匹配
     * @param info
     * @return
     */
    boolean match(MessageFilterInfo info);
}
