package com.bxm.localnews.msg.service.filter;

import com.bxm.localnews.mq.common.constant.MessageFilterEventTypeEnum;

/**
 *
 * 消息召回（对要下发的消息做些什么）处理
 *
 * 需要在下发该类型消息时候做些什么
 *
 * @author pf.w
 * @date 2020/11/28 16:08
 **/
public interface MessageFilterStrategy {

    /**
     * 消息召回处理逻辑
     *
     * 说明 : 目前只有评论消息的处理，预见扩展有限，后续有类似需求再做完善
     * @param param
     * @return
     */
    Object filter(Object param,String msgType);

    /**
     * 策略匹配
     * @param messageFilterType
     * @return
     */
    boolean match(MessageFilterEventTypeEnum messageFilterType);
}
