package com.bxm.localnews.msg.service.filter;

import com.bxm.localnews.mq.common.constant.MessageFilterEventTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author pf.w
 * @date 2020/11/28 16:34
 **/
@Component
public class MessageFilterStrategyManage {

    private final List<MessageFilterStrategy> strategyList;

    @Autowired
    public MessageFilterStrategyManage(List<MessageFilterStrategy> strategyList){
        this.strategyList = strategyList;
    }

    /**
     * 策略模式 不同类型不同处理
     * @param
     */
    public Object excute(Object param,String msgType,MessageFilterEventTypeEnum messageFilterType){
        for (MessageFilterStrategy messageFilterStrategy : strategyList) {
            if(messageFilterStrategy.match(messageFilterType)){
                return messageFilterStrategy.filter(param,msgType);
            }
        }
        return param;
    }
}
