package com.bxm.localnews.msg.service.filter.impl;

import com.bxm.localnews.mq.common.model.dto.MessageFilterInfo;
import com.bxm.localnews.msg.service.filter.FilterSaveStrategyManage;
import com.bxm.localnews.msg.service.filter.UserMessageFilterService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author pf.w
 * @date 2020/11/26 15:59
 **/
@Service
@Slf4j
public class UserMessageFilterServiceImpl implements UserMessageFilterService {

    @Resource
    private FilterSaveStrategyManage filterSaveStrategyManage;

    @Override
    public void addMessageFilter(MessageFilterInfo info) {
        if(log.isDebugEnabled()){
            log.debug("info : {}",info);
        }

        saveToRedis(info);

    }

    private void saveToRedis(MessageFilterInfo info){
        //评论消息 因为需求逻辑关系，这边直接存储评论id集合 后续可用策略模式

        filterSaveStrategyManage.excute(info);

        //时间紧任务重 其他类型 等有相关需求再处理
        // 不同类型 redisHashMapAdapter -value 可以放置不同的值
        //策略模式

    }

}
