package com.bxm.localnews.msg.service.filter.process.filter;

import com.bxm.localnews.mq.common.constant.MessageFilterEventTypeEnum;
import com.bxm.localnews.msg.config.MessageTypeProperties;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.service.filter.MessageFilterStrategy;
import com.bxm.localnews.msg.vo.UserMessageBean;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 * 3.9.0需求
 *
 * 下发的评论消息做过滤（评论设置仅用户可见时更改消息状态为删除）
 *
 * @author pf.w
 * @date 2020/11/28 16:13
 **/
@Service
public class ReplyFilterStrategy implements MessageFilterStrategy {

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private MessageTypeProperties messageTypeProperties;

    @Override
    public Object filter(Object param,String msgType) {
        UserMessageBean result = null;
        if(param instanceof UserMessageBean){
            result = (UserMessageBean) param;
            if(Objects.nonNull(result.getReplyId()) && messageTypeProperties.isInteraction(msgType)){
                if(checkReply(result.getReplyId())){
                    result.setStatus((byte)2);
                    result.setReadStatus(result.getStatus());
                    result.setContent("该评论已删除！");
                }
            }
        }
        return result;
    }

    @Override
    public boolean match(MessageFilterEventTypeEnum messageFilterType) {
         return Objects.equals(messageFilterType,MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT);
    }

    private boolean checkReply(Long replyId){
        TypeReference<List<Long>> typeReference = new TypeReference<List<Long>>() {
        };
        List<Long> replyIds = redisHashMapAdapter.get(RedisConfig.MESSAGE_FILTER_CONTENT_KEY.copy()
                ,MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT.name().toLowerCase()
                ,typeReference);

        if(CollectionUtils.isEmpty(replyIds)){
            return false;
        }
        return replyIds.contains(replyId);
    }
}
