package com.bxm.localnews.msg.service.filter.process.save;

import com.bxm.localnews.mq.common.constant.MessageFilterEventTypeEnum;
import com.bxm.localnews.mq.common.model.dto.MessageFilterInfo;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.service.filter.MessageFilterSaveStrategy;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 * @author pf.w
 * @date 2020/11/26 17:37
 **/
@Service
public class ReplyFilterSaveStrategy implements MessageFilterSaveStrategy {

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public void saveLogic(MessageFilterInfo info) {
        //评论消息 因为需求逻辑关系，这边直接存储评论id集合
        if(Objects.equals(info.getEventTypeEnum(),MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT)){

            TypeReference<List<Long>> typeReference = new TypeReference<List<Long>>() {
            };
            List<Long> replyIds = redisHashMapAdapter.get(key()
                    ,info.getEventTypeEnum().name().toLowerCase()
                    ,typeReference);

            if(CollectionUtils.isEmpty(replyIds)){
                redisHashMapAdapter.put(key(),info.getEventTypeEnum().name().toLowerCase(), Lists.newArrayList(info.getLogicId()));
            }else{
                replyIds.add(info.getLogicId());
                redisHashMapAdapter.put(key(),info.getEventTypeEnum().name().toLowerCase(),replyIds);
            }
        }
    }

    @Override
    public boolean match(MessageFilterInfo info) {
        return Objects.equals(info.getEventTypeEnum(),MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT);
    }

    private KeyGenerator key(){
        return RedisConfig.MESSAGE_FILTER_CONTENT_KEY.copy();
    }
}
