package com.bxm.localnews.msg.stream.impl;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.param.PushMessageBucket;
import com.bxm.localnews.msg.stream.MessageProcessor;
import com.bxm.localnews.msg.stream.MessageProvider;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.MessageChannel;

import javax.annotation.Resource;

/**
 * 消息输出代理实现
 * 通过 {@link EnableBinding} 激活输出通道
 * 注入的{@link MessageChannel} beanName与 {@link MessageProcessor} 中保持一致，用于选择对应的通道
 *
 * @author liujia
 */
@EnableBinding(MessageProcessor.class)
public class MessageProviderImpl implements MessageProvider {

    @Resource
    private MessageChannel singlePushOutput;

    @Resource
    private MessageChannel batchPushOutput;

    @Resource
    private MessageChannel userEventOutput;

    @Override
    public void singlePush(PushMessage message) {
        singlePushOutput.send(MessageBuilder.withPayload(message).build());
    }

    @Override
    public void batchPush(PushMessageBucket bucket) {
        batchPushOutput.send(MessageBuilder.withPayload(bucket).build());
    }

    @Override
    public void userEvent(Long userId) {
        userEventOutput.send(MessageBuilder.withPayload(userId).build());
    }
}
