package com.bxm.localnews.msg.utils;

import java.util.Calendar;
import java.util.Date;

public class IntervalPeriodUtils {
    private IntervalPeriodUtils() {
    }

    /**
     * 每半个小时作为一个片区，计算片区索引
     * @return 索引下标
     */
    public static int getIntervalIndex() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());

        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        int minute = calendar.get(Calendar.MINUTE);

        return hour * 2 + minute / 30;
    }

    /**
     * 获取当前时间的前一个索引
     * @return 索引下标
     */
    public static int getPreIntervalIndex() {
        int index = getIntervalIndex() - 1;
        if (index == -1) {
            //23*2 + 1
            index = 47;
        }
        return index;
    }
}
