/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.msg.config.SmsProperties;
import com.bxm.localnews.msg.service.SmsSender;
import com.bxm.localnews.msg.service.impl.ShiyuanApiImpl;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiyuanSender
implements SmsSender {
    private static final Logger log = LoggerFactory.getLogger(ShiyuanSender.class);
    private SmsProperties smsProperties;
    private ShiyuanApiImpl shiyuanApi;

    private SmsProperties getMessageProperties() {
        if (this.smsProperties == null) {
            this.smsProperties = (SmsProperties)SpringContextHolder.getBean(SmsProperties.class);
        }
        return this.smsProperties;
    }

    private ShiyuanApiImpl getApi() {
        if (this.shiyuanApi == null) {
            this.shiyuanApi = (ShiyuanApiImpl)SpringContextHolder.getBean(ShiyuanApiImpl.class);
        }
        return this.shiyuanApi;
    }

    @Override
    public String[] send(String phone, String msg) {
        String result = "";
        this.smsProperties = this.getMessageProperties();
        try {
            result = this.getApi().batchSend(this.smsProperties.getShiyuanUrl(), this.smsProperties.getShiyuanAccount(), this.smsProperties.getShiyuanPwd(), phone, msg, true, "", "");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.processResult(result);
    }

    private String[] processResult(String result) {
        String[] arr = result.split("\\n");
        String[] re = new String[2];
        if (arr.length > 1) {
            String[] responseArray = arr[0].split(",");
            if (responseArray.length == 2) {
                if ("0".equals(responseArray[1])) {
                    re[0] = "1";
                    re[1] = arr[0] + " | " + arr[1];
                } else {
                    re[0] = "0";
                    re[1] = arr[0];
                }
            }
        } else {
            re[0] = "0";
            re[1] = arr[0];
        }
        return re;
    }
}

