/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.mq.common.constant.AppConst;
import com.bxm.localnews.mq.common.constant.RedisConfig;
import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.msg.config.SmsProperties;
import com.bxm.localnews.msg.domain.SmsMapper;
import com.bxm.localnews.msg.service.SmsMessageHandle;
import com.bxm.localnews.msg.service.SmsSupplyService;
import com.bxm.localnews.msg.vo.Sms;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="smsSupplyService")
@RefreshScope
public class SmsSupplyServiceImpl
implements SmsSupplyService {
    @Resource
    private SmsMessageHandle smsMessageHandle;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private SmsMapper smsMapper;
    @Resource
    private SmsProperties smsProperties;

    @Override
    public SendSmsResult sendSmsByTemplate(String phoneNo, SmsTemplateEnum smsTemplate, String ip, String ... params) {
        if (!this.sendSmsSafeLimit(phoneNo, ip, smsTemplate)) {
            return SendSmsResult.build((boolean)false, (String)"\u8be5\u624b\u673a\u77ed\u4fe1\u5f53\u5929\u53d1\u9001\u5230\u8fbe\u4e0a\u9650");
        }
        String smsContent = com.bxm.newidea.component.tools.StringUtils.convertMessage((String)smsTemplate.getContent(), (String[])params);
        HashMap<String, String> smsMap = new HashMap<String, String>();
        smsMap.put("phoneNo", phoneNo);
        smsMap.put("content", smsContent);
        this.smsMessageHandle.send(smsMap);
        this.saveSendSmsSafeNum(phoneNo, ip, smsTemplate);
        this.saveSmsRecord(phoneNo, null, ip, null, smsContent, null);
        return SendSmsResult.build((boolean)true, (String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536");
    }

    @Override
    public SendSmsResult sendSmsByCustomize(String phoneNo, String smsContent) {
        HashMap<String, String> smsMap = new HashMap<String, String>();
        smsMap.put("phoneNo", phoneNo);
        smsMap.put("content", smsContent);
        this.smsMessageHandle.send(smsMap);
        this.saveSmsRecord(phoneNo, null, null, null, smsContent, null);
        return SendSmsResult.build((boolean)true, (String)"\u77ed\u4fe1\u5df2\u53d1\u9001");
    }

    @Override
    public void sendGroupSmsByTemplate(List<String> phoneNos, SmsTemplateEnum smsTemplate, String ... params) {
        String smsContent = com.bxm.newidea.component.tools.StringUtils.convertMessage((String)smsTemplate.getContent(), (String[])params);
        HashMap<String, String> smsMap = new HashMap<String, String>();
        smsMap.put("content", smsContent);
        this.execSend(phoneNos, smsContent, smsMap);
    }

    @Override
    public void sendGroupSmsByCustomize(List<String> phoneNos, String smsContent) {
        HashMap<String, String> smsMap = new HashMap<String, String>();
        smsMap.put("content", smsContent);
        this.execSend(phoneNos, smsContent, smsMap);
    }

    private void execSend(List<String> phoneNos, String smsContent, Map<String, String> smsMap) {
        for (String phoneNo : phoneNos) {
            smsMap.put("phoneNo", phoneNo);
            this.smsMessageHandle.send(smsMap);
            this.saveSmsRecord(phoneNo, null, null, null, smsContent, null);
        }
    }

    @Override
    public Boolean verifySmsCode(String phoneNo, String code, SmsTemplateEnum smsTemplate) {
        KeyGenerator key = RedisConfig.MESSAGE_SMS.copy().appendKey((Object)(smsTemplate.name().toLowerCase() + ":" + phoneNo));
        String vCode = (String)this.redisStringAdapter.get(key, String.class);
        return code.equals(vCode);
    }

    @Override
    public Boolean verifySmsCodeByType(Byte type, String phoneNo, String code) {
        SmsTemplateEnum smsTemplateEnum = SmsTemplateEnum.getTemplateByType((Byte)type);
        return this.verifySmsCode(phoneNo, code, smsTemplateEnum);
    }

    @Override
    public SendSmsResult sendSmsByVCodeTemplate(String phoneNo, SmsTemplateEnum smsTemplate, String ip) {
        Assert.isTrue((boolean)smsTemplate.isVCodeType(), (String)"\u6a21\u7248\u7c7b\u578b\u4e0d\u652f\u6301");
        String code = RandomUtils.getShortCode((int)4);
        KeyGenerator key = RedisConfig.MESSAGE_SMS.copy().appendKey((Object)(smsTemplate.name().toLowerCase() + ":" + phoneNo));
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            this.redisStringAdapter.remove(key);
        }
        this.redisStringAdapter.set(key, (Object)code, 600L);
        return this.sendSmsByTemplate(phoneNo, smsTemplate, ip, code);
    }

    private boolean sendSmsSafeLimit(String phoneNo, String ip, SmsTemplateEnum templateEnum) {
        boolean dayResult;
        KeyGenerator dayKey = RedisConfig.MESSAGE_SMS.copy().appendKey((Object)("limit:" + templateEnum.name().toLowerCase() + ":" + phoneNo));
        boolean bl = dayResult = this.redisStringAdapter.getLong(dayKey).intValue() < this.smsProperties.getPhoneLimitPerDay();
        if (!StringUtils.isEmpty((Object)ip)) {
            KeyGenerator ipKey = RedisConfig.MESSAGE_SMS.copy().appendKey((Object)("limit:" + templateEnum.name().toLowerCase() + ":" + ip));
            return dayResult && this.redisStringAdapter.getLong(ipKey).intValue() < this.smsProperties.getIpLimitPerDay();
        }
        return dayResult;
    }

    private void saveSendSmsSafeNum(String phoneNo, String ip, SmsTemplateEnum templateEnum) {
        KeyGenerator dayKey = RedisConfig.MESSAGE_SMS.copy().appendKey((Object)("limit:" + templateEnum.name().toLowerCase() + ":" + phoneNo));
        this.redisStringAdapter.increment(dayKey);
        this.redisStringAdapter.expire(dayKey, (long)DateUtils.getCurSeconds());
        if (!StringUtils.isEmpty((Object)ip)) {
            KeyGenerator ipKey = RedisConfig.MESSAGE_SMS.copy().appendKey((Object)("limit:" + templateEnum.name().toLowerCase() + ":" + ip));
            this.redisStringAdapter.increment(ipKey);
            this.redisStringAdapter.expire(ipKey, (long)DateUtils.getCurSeconds());
        }
    }

    private void saveSmsRecord(String phone, Byte type, String ip, String vcode, String content, String[] result) {
        Date date = new Date();
        Sms sms = new Sms();
        sms.setPhone(phone);
        sms.setSendTime(date);
        sms.setSmsType(type);
        sms.setCode(vcode);
        sms.setState(AppConst.Sms.STATUS_UNUSED);
        if (ArrayUtils.isNotEmpty((Object[])result)) {
            sms.setResp(result[0]);
            sms.setContent(result[1]);
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)content)) {
            sms.setContent(content);
        }
        sms.setIp(ip);
        sms.setRespTime(date);
        sms.setCreateTime(date);
        this.smsMapper.insertSelective(sms);
    }
}

