/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.localnews.news.action.PostReportService;
import com.bxm.localnews.news.action.PostShareService;
import com.bxm.localnews.news.activity.ForumPostGuideService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.create.PostCreateService;
import com.bxm.localnews.news.detail.ForumPostDetailService;
import com.bxm.localnews.news.detail.context.PostDetailOriginalParam;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.forum.ForumService;
import com.bxm.localnews.news.list.PostListService;
import com.bxm.localnews.news.model.dto.ForumPostCreateDTO;
import com.bxm.localnews.news.model.dto.ForumPostLikeDTO;
import com.bxm.localnews.news.model.dto.ForumPostTodayDTO;
import com.bxm.localnews.news.model.dto.HotForumListShareDTO;
import com.bxm.localnews.news.model.dto.PostLikeDto;
import com.bxm.localnews.news.model.param.FollowUserForumsParam;
import com.bxm.localnews.news.model.param.ForumPostCollectParam;
import com.bxm.localnews.news.model.param.ForumPostInformParam;
import com.bxm.localnews.news.model.param.ForumPostListQueryParam;
import com.bxm.localnews.news.model.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.model.param.HomePagePostParam;
import com.bxm.localnews.news.model.param.HotForumListShareParam;
import com.bxm.localnews.news.model.param.HotForumsParam;
import com.bxm.localnews.news.model.vo.FollowUserForumPostVo;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.ForumVo;
import com.bxm.localnews.news.model.vo.HotForumPostVo;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.post.HotPostService;
import com.bxm.localnews.news.post.PostRecommendIntegrationService;
import com.bxm.localnews.news.recommend.RecommendPostService;
import com.bxm.localnews.news.service.NewsCollectService;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-10 \u793e\u533a\u7248\u5757\u4fe1\u606f\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"api/forum"})
public class ForumController
extends BaseController {
    private ForumPostService forumPostService;
    private ForumProperties forumProperties;
    private ForumTopicService forumTopicService;
    private ForumService forumService;
    private SequenceCreater sequenceCreate;
    private DistributedLock distributedLock;
    private ForumPostDetailService forumPostDetailService;
    private HotPostService hotPostService;
    private PostListService postListService;
    private PostLikeService postLikeService;
    private ForumPostGuideService forumPostGuideService;
    private RecommendPostService recommendPostService;
    private PostReportService postReportService;
    private PostShareService postShareService;
    private NewsCollectService newsCollectService;
    private PostRecommendIntegrationService postRecommendIntegrationService;
    private PostCreateService postCreateService;

    @ApiOperation(value="4-10-1 \u6839\u636e\u5730\u533a\u83b7\u53d6\u7248\u5757\u5217\u8868", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a", required=true), @ApiImplicitParam(name="size", value="\u5c55\u793a\u6570\u91cf(\u9ed8\u8ba4\u4e3a-1\u8868\u793a\u5c55\u793a\u5168\u90e8)"), @ApiImplicitParam(name="userId", value="\u7528\u6237id")})
    @GetMapping(value={"getForumListByArea"})
    public Json<List<ForumVo>> getForumListByArea(@RequestParam(value="areaCode") String areaCode, @RequestParam(value="size", required=false) Integer size, @RequestParam(value="userId") Long userId, BasicParam basicParam) throws BindException {
        this.combo().prop("areaCode", (Object)areaCode).notBlank("\u5730\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a").max(12L, "\u6700\u957f\u957f\u5ea6\u53ea\u80fd\u4e3a12").prop("userId", (Object)userId).notBlank("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a").valid();
        return ResultUtil.genSuccessResult((Object)this.forumService.listForum(areaCode, size, userId, basicParam));
    }

    @ApiOperation(value="4-10-2 \u6839\u636e\u5730\u533a\u83b7\u53d6\u8bdd\u9898\u5217\u8868", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a", required=true), @ApiImplicitParam(name="size", value="\u5c55\u793a\u6570\u91cf(\u9ed8\u8ba4\u4e3a-1\u8868\u793a\u5c55\u793a\u5168\u90e8)"), @ApiImplicitParam(name="userId", value="\u7528\u6237id"), @ApiImplicitParam(name="postPage", value="\u662f\u5426\u53d1\u5e16\u9875\u9762, 0\u54261\u662f")})
    @GetMapping(value={"getTopicListByArea"})
    public Json<List<TopicVo>> getTopicListByArea(@RequestParam(value="areaCode", required=false) String areaCode, @RequestParam(value="size", required=false) Integer size, @RequestParam(value="userId") Long userId, @RequestParam(value="postPage", required=false) Integer postPage) throws BindException {
        return ResultUtil.genSuccessResult((Object)this.forumTopicService.listTopic(areaCode, size, userId, postPage));
    }

    @ApiOperation(value="4-10-3 \u6839\u636eid\u83b7\u53d6\u7248\u5757", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801"), @ApiImplicitParam(name="userId", value="\u7528\u6237id")})
    @GetMapping(value={"getForumById"})
    public Json<ForumVo> getForumById(Long id, Long userId, String areaCode) throws BindException {
        this.combo().prop("areaCode", (Object)areaCode).notBlank("\u5730\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a").max(12L, "\u6700\u957f\u957f\u5ea6\u53ea\u80fd\u4e3a12").prop("userId", (Object)userId).notBlank("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a").prop("id", (Object)id).notBlank("\u677f\u5757id\u4e0d\u80fd\u4e3a\u7a7a").valid();
        return ResultUtil.genSuccessResult((Object)this.forumService.getForumDetail(id, userId, areaCode));
    }

    @ApiOperation(value="4-10-4 \u6839\u636eid\u83b7\u53d6\u8bdd\u9898", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801"), @ApiImplicitParam(name="userId", value="\u7528\u6237id"), @ApiImplicitParam(name="type", value="3.10.0  \u53d1\u5e16\u6309\u94ae\u8fc7\u6765\u7684type\u503c  910001\uff1a\u968f\u4fbf\u804a\u804a    910002\uff1a\u672c\u5730\u7206\u6599  \u4e3a\u8be6\u60c5\u5f39\u7a97\u7528 \u53ef\u4e3a\u7a7a")})
    @GetMapping(value={"getTopicById"})
    public Json<TopicVo> getTopicById(Long id, Long userId, String areaCode, Integer type) throws BindException {
        this.combo().prop("areaCode", (Object)areaCode).notBlank("\u5730\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a").max(12L, "\u6700\u957f\u957f\u5ea6\u53ea\u80fd\u4e3a12").prop("userId", (Object)userId).notBlank("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a").prop("id", (Object)id).notBlank("\u8bdd\u9898id\u4e0d\u80fd\u4e3a\u7a7a").valid();
        return ResultUtil.genSuccessResult((Object)this.forumTopicService.getTopicDetailNew(id, userId, areaCode, type));
    }

    @ApiOperation(value="4-10-5 \u6839\u636e\u7248\u5757\u6216\u8bdd\u9898\u83b7\u53d6\u5e16\u5b50\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"getPostPage"})
    public Json<PageWarper<ForumPostVo>> getPostPage(@Valid ForumPostListQueryParam param, BasicParam basicParam) {
        return ResultUtil.genSuccessResult((Object)this.recommendPostService.listForumPost(param, basicParam));
    }

    @ApiOperation(value="4-10-6 \u6839\u636e\u7528\u6237\u53ca\u7c7b\u578b\u83b7\u53d6\u5e16\u5b50\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"getPostPageByUser"})
    public Json<PageWarper<ForumPostVo>> getPostPageByUser(ForumPostListUserQueryParam param) {
        return ResultUtil.genSuccessResult((Object)this.postListService.listForumPostByUser(param));
    }

    @ApiOperation(value="4-10-7 \u6839\u636eid\u83b7\u53d6\u5e16\u5b50\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e16\u5b50id", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="shareUserId", value="\u8f6c\u53d1\u8005\u7528\u6237id"), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801")})
    @GetMapping(value={"getPostDetailById"})
    public Json<ForumPostVo> getPostDetailById(Long id, Long userId, @RequestParam(value="shareUserId", required=false) Long shareUserId, @RequestParam(value="areaCode", required=false) String areaCode, BasicParam basicParam, HttpServletRequest request) {
        PostDetailOriginalParam param = new PostDetailOriginalParam();
        param.setId(id);
        param.setUserId(userId);
        param.setShareUserId(shareUserId);
        param.setIp(WebUtils.getIpAddr((HttpServletRequest)request));
        param.setBasicParam(basicParam);
        param.setAreaCode(areaCode);
        return ResultUtil.genSuccessResult((Object)this.forumPostDetailService.get(param));
    }

    @ApiOperation(value="4-10-8 \u53d1\u5e03\u6216\u7f16\u8f91\u5e16\u5b50", httpMethod="POST", notes="\u9996\u6b21\u53d1\u5e16\u5956\u52b1100\u5c0f\u7ea2\u82b1\uff0c\u6bcf\u592910\u6b21\u53d1\u5e16\u83b7\u5f9720\u5c0f\u7ea2\u82b1")
    @PostMapping(value={"public/createOrUpdatePost"})
    public Json<ForumPostCreateDTO> createOrUpdatePost(@RequestBody ForumBasicVo forumBasicVo, BasicParam basicParam) {
        Message message = this.postCreateService.saveUserPost(forumBasicVo, basicParam, false);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult((String)((String)message.getMessages().get(0)));
        }
        ForumPostCreateDTO forumPostCreateDTO = (ForumPostCreateDTO)message.getParam("completeTaskAndPush");
        if (forumPostCreateDTO == null) {
            forumPostCreateDTO = new ForumPostCreateDTO();
        }
        return ResultUtil.genSuccessResult((Object)forumPostCreateDTO);
    }

    @ApiOperation(value="4-10-9 \u5220\u9664\u5e16\u5b50", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e16\u5b50id", required=true)})
    @PostMapping(value={"delete"})
    public Json<Boolean> delete(Long id) {
        Message message = this.forumPostService.deleteForumPost(id);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="4-10-10 \u5e16\u5b50\u70b9\u51fb\u6b21\u6570+1", httpMethod="POST", notes="\u6682\u65f6\u4e0d\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e16\u5b50id", required=true)})
    @PostMapping(value={"addClick"})
    @Deprecated
    public Json addClick(Long id) {
        return ResultUtil.genSuccessResult();
    }

    @Deprecated
    @ApiOperation(value="4-10-11 [\u65e7\u7248]\u70b9\u8d5e\u3001\u53d6\u6d88\u70b9\u8d5e", notes="\u70b9\u8d5e\u3001\u53d6\u6d88\u70b9\u8d5e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postId", value="\u5e16\u5b50ID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="type", value="0\uff1a\u53d6\u6d88\u70b9\u8d5e\uff0c1\uff1a\u70b9\u8d5e", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=true)})
    @PostMapping(value={"like"})
    public Json like(Long postId, Long userId, int type, String areaCode, BasicParam basicParam) {
        this.postLikeService.doLikeForumPost(userId, postId, type, areaCode, Integer.valueOf(basicParam.getPlatform()));
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="4-10-12 \u6536\u85cf\u6216\u53d6\u6d88\u6536\u85cf\u5e16\u5b50")
    @RequestMapping(value={"collect"}, method={RequestMethod.POST})
    public Json collect(ForumPostCollectParam forumPostCollectParam) {
        NewsCollect newsCollect = new NewsCollect(forumPostCollectParam.getUserId(), forumPostCollectParam.getPostId(), Byte.valueOf((byte)3));
        this.newsCollectService.collectNews(newsCollect, Integer.valueOf(forumPostCollectParam.getPlatform()), forumPostCollectParam.getAreaCode());
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="4-10-13 \u5e16\u5b50\u4e3e\u62a5")
    @RequestMapping(value={"inform"}, method={RequestMethod.POST})
    public Json inform(ForumPostInformParam forumPostInformParam) {
        return ResultUtil.genSuccessResult((Object)this.postReportService.doInformForumPost(forumPostInformParam));
    }

    @ApiOperation(value="4-10-14 \u5e16\u5b50\u5206\u4eab\u83b7\u5f97\u91d1\u5e01\uff08\u8fd4\u56de\u7c7b\u548c\u65b0\u95fb\u4e00\u6837\uff09", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postId", value="\u5e16\u5b50ID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=true), @ApiImplicitParam(name="type", value="\u9ed8\u8ba4\u4e3a1 \u7c7b\u578b\uff1a1 \u666e\u901a\u5206\u4eab  2 \u5c0f\u7a0b\u5e8f\u8be6\u60c5\u5f39\u7a97\u8f6c\u53d1\uff08\u6bcf\u5929\u4e00\u6b21\u53ef\u83b7\u5f9780\u7ea2\u82b1\uff093.\u8865\u7b7e\u5206\u4eab 4.\u4efb\u52a1\u70b9\u8f6c\u53d1\u83b7\u53d6\u63a8\u8350\u6c60\u6587\u7ae0\u5206\u4eab")})
    @RequestMapping(value={"share"}, method={RequestMethod.POST})
    public Json<NewsCompleTaskDTO> share(@RequestParam(value="postId") Long postId, @RequestParam(value="userId") Long userId, @RequestParam(value="areaCode") String areaCode, @RequestParam(value="type", required=false) Byte type, BasicParam basicParam) {
        if (null == type) {
            type = 1;
        }
        return ResultUtil.genSuccessResult((Object)this.postShareService.doShareForumPost(userId, postId, areaCode, type, Integer.valueOf(basicParam.getPlatform())));
    }

    @ApiOperation(value="4-10-15 \u5e16\u5b50\u8be6\u60c5\u76f8\u5173\u63a8\u8350", httpMethod="GET", notes="\u5982\u679c\u662f15\u6761\uff0c\u52195\u6761\u672c\u5730\u65b0\u95fb 10\u6761\u5e16\u5b50\uff0c\u5982\u679c\u662f5\u6761\uff0c\u52192\u6761\u672c\u5730\uff0c3\u6761\u5e16\u5b50")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postId", value="\u5e16\u5b50ID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID"), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u53f7"), @ApiImplicitParam(name="size", value="\u63a8\u8350\u4e2a\u6570")})
    @GetMapping(value={"detail/recommend"})
    public Json<List<News4Client>> recommend(@RequestParam(value="postId", required=false) Long postId, @RequestParam(value="userId", required=false) Long userId, @RequestParam(value="areaCode", required=false) String areaCode, @RequestParam(value="size", required=false) Integer size, @RequestParam(value="platform", required=false) Integer platform) {
        return ResultUtil.genSuccessResult((Object)this.postRecommendIntegrationService.listPostDetailRecommend(postId, userId, size, areaCode, platform));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="4-10-17 [\u65b0\u7248]\u5e16\u5b50\u70b9\u8d5e", notes="\u5e16\u5b50\u70b9\u8d5e\uff0c\u65e0\u6cd5\u53d6\u6d88\u70b9\u8d5e\u54e6\u4eb2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postId", value="\u5e16\u5b50ID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="userNickname", value="\u7528\u6237\u6635\u79f0", required=true), @ApiImplicitParam(name="headImg", value="\u7528\u6237\u5934\u50cf", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=false)})
    @PostMapping(value={"new/like"})
    public Json<PostLikeDto> newLike(@RequestParam(value="postId", required=true) Long postId, @RequestParam(value="userId", required=true) Long userId, @RequestParam(value="userNickname", required=false) String userNickname, @RequestParam(value="headImg", required=false) String headImg, @RequestParam(value="areaCode", required=true) String areaCode, BasicParam basicParam) {
        KeyGenerator lockKey = RedisConfig.FORUMPOST_LIKE_LOCK.copy().appendKey((Object)userId).appendKey((Object)postId);
        String stringId = this.sequenceCreate.nextStringId();
        PostLikeDto postLikeDto = null;
        if (this.distributedLock.lock(lockKey.gen(), stringId, 30L, TimeUnit.SECONDS)) {
            try {
                postLikeDto = this.postLikeService.doLikeForumPost(postId, userId, areaCode, Integer.valueOf(basicParam.getPlatform()));
            }
            finally {
                this.distributedLock.unlock(lockKey.gen(), stringId);
            }
        }
        if (null != postLikeDto) {
            return ResultUtil.genSuccessResult(postLikeDto);
        }
        return ResultUtil.genFailedResult((String)"");
    }

    @ApiOperation(value="4-10-18 \u6839\u636e\u5e16\u5b50id\u83b7\u5f97\u70b9\u8d5e\u5217\u8868", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postId", value="\u5e16\u5b50id", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="devcId", value="\u8bbe\u5907id", required=false)})
    @GetMapping(value={"getPostLikeDetailById"})
    public Json<List<ForumPostLikeDTO>> getPostLikeDetailById(Long postId, Long userId, String devcId) {
        return ResultUtil.genSuccessResult((Object)this.postLikeService.getPostLikeDetail(postId, userId, devcId));
    }

    @ApiOperation(value="4-10-19 \u6839\u636e\u5e16\u5b50id\u5217\u8868\u83b7\u53d6\u5e16\u5b50\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postIds", value="\u5e16\u5b50id\u5217\u8868\uff0c\u9017\u53f7\u5206\u9694", required=true)})
    @GetMapping(value={"public/getPostListByIds"})
    public Json<List<ForumPostVo>> getPostListByIds(String postIds) {
        return ResultUtil.genSuccessResult((Object)this.postListService.getPostListByIds(postIds));
    }

    @ApiOperation(value="4-10-20 \u83b7\u53d6\u73b0\u91d1\u5956\u52b1\u5e16\u5b50\u8f6e\u64ad\u5217\u8868")
    @GetMapping(value={"getRewardPostList"})
    public Json<List<ForumPostVo>> getRewardPostList() {
        return ResultUtil.genSuccessResult((Object)this.postListService.getRewardPostList());
    }

    @ApiOperation(value="4-10-21 \u83b7\u53d6\u7206\u6599\u6709\u5956\u9875\u9762\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="isLogin", value="\u662f\u5426\u767b\u5f55", required=false), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=false)})
    @GetMapping(value={"getPublishRewardUrl"})
    public Json<String> getPublishRewardUrl(@RequestParam(value="isLogin", required=false) String isLogin, @RequestParam(value="userId", required=false) String userId, @RequestParam(value="areaCode", required=false) String areaCode) {
        return ResultUtil.genSuccessResult((Object)(this.forumProperties.getPublishRewardUrl() + "?isLogin=" + isLogin + "&userId=" + userId + "&areaCode=" + areaCode));
    }

    @ApiOperation(value="4-10-22 \u672c\u5730\u5708\u662f\u5426\u6709\u5185\u5bb9\u66f4\u65b0 true\u6709\u66f4\u65b0;false \u65e0\u65b0\u5185\u5bb9\u66f4\u65b0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="lastRequestTime", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=true)})
    @GetMapping(value={"haveContentUpdate"})
    public Json<Boolean> haveContentUpdate(Date lastRequestTime, String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.forumPostService.getContentUpdate(lastRequestTime, areaCode));
    }

    @ApiOperation(value="4-10-24 \u4e2a\u4eba\u4e3b\u9875 \u5e16\u5b50\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"getHomePagePostList"})
    public Json<PageWarper<ForumPostVo>> getHomePagePostList(HomePagePostParam param, BasicParam basicParam) {
        return ResultUtil.genSuccessResult((Object)this.postListService.getHomePagePostList(param, basicParam));
    }

    @ApiOperation(value="4-10-25 \u7528\u6237\u4eca\u65e5\u662f\u5426\u53d1\u5e16\u6d6e\u7a97\u63a5\u53e3", notes="\u7528\u6237\u4eca\u65e5\u662f\u5426\u53d1\u5e16\u63a5\u53e3", httpMethod="GET", nickname="wpf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    @GetMapping(value={"forumOkTodayForUser"})
    public ResponseJson<ForumPostTodayDTO> forumOkTodayForUser(Long userId) {
        return ResponseJson.ok((Object)this.forumPostGuideService.forumOkTodayForUser(userId));
    }

    @ApiOperation(value="4-10-26 \u70ed\u95e8\u5e16\u5b50\u5185\u5bb9\u699c", notes="\u70ed\u95e8\u5e16\u5b50\u5185\u5bb9\u699c", httpMethod="GET", nickname="wpf")
    @GetMapping(value={"public/getHotForums"})
    public ResponseJson<PageWarper<HotForumPostVo>> getHotForums(HotForumsParam param, BasicParam basicParam) {
        return ResponseJson.ok((Object)this.hotPostService.hotForumPost(param, basicParam));
    }

    @ApiOperation(value="4-10-27 \u70ed\u95e8\u5e16\u5b50\u5206\u4eab\u57fa\u672c\u4fe1\u606f", notes="\u70ed\u95e8\u5e16\u5b50\u5206\u4eab\u57fa\u672c\u4fe1\u606f", httpMethod="GET", nickname="wpf")
    @GetMapping(value={"getHotForumShareInfo"})
    public ResponseJson<HotForumListShareDTO> hotForumsShareBaseInfo(HotForumListShareParam param) {
        return ResponseJson.ok((Object)this.hotPostService.hotForumsShareBaseInfo(param));
    }

    @ApiOperation(value="4-10-28 \u5173\u6ce8\u7528\u6237\u5e16\u5b50\u5217\u8868", httpMethod="GET", nickname="pf.w")
    @GetMapping(value={"followUserForums"})
    public ResponseJson<FollowUserForumPostVo> followUserForums(@Valid FollowUserForumsParam param, BasicParam basicParam) {
        return ResponseJson.ok((Object)this.postListService.getFollowedUserForumList(param, basicParam));
    }

    public ForumController(ForumPostService forumPostService, ForumProperties forumProperties, ForumTopicService forumTopicService, ForumService forumService, SequenceCreater sequenceCreate, DistributedLock distributedLock, ForumPostDetailService forumPostDetailService, HotPostService hotPostService, PostListService postListService, PostLikeService postLikeService, ForumPostGuideService forumPostGuideService, RecommendPostService recommendPostService, PostReportService postReportService, PostShareService postShareService, NewsCollectService newsCollectService, PostRecommendIntegrationService postRecommendIntegrationService, PostCreateService postCreateService) {
        this.forumPostService = forumPostService;
        this.forumProperties = forumProperties;
        this.forumTopicService = forumTopicService;
        this.forumService = forumService;
        this.sequenceCreate = sequenceCreate;
        this.distributedLock = distributedLock;
        this.forumPostDetailService = forumPostDetailService;
        this.hotPostService = hotPostService;
        this.postListService = postListService;
        this.postLikeService = postLikeService;
        this.forumPostGuideService = forumPostGuideService;
        this.recommendPostService = recommendPostService;
        this.postReportService = postReportService;
        this.postShareService = postShareService;
        this.newsCollectService = newsCollectService;
        this.postRecommendIntegrationService = postRecommendIntegrationService;
        this.postCreateService = postCreateService;
    }
}

