/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.KindDTO;
import com.bxm.localnews.news.service.NewsKindService;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-05 \u65b0\u95fb\u9891\u9053\u76f8\u5173\u63a5\u53e3"}, description="\u7528\u6237\u5bf9\u9891\u9053\u7684\u64cd\u4f5c")
@RequestMapping(value={"api/kind"})
@RestController
@Deprecated
public class KindController {
    @Resource
    private NewsKindService newsKindService;

    @ApiOperation(value="4-05-01 \u6211\u7684\u9891\u9053", httpMethod="GET", notes="2.1.0\u65b0\u63a5\u53e3\u9700\u8981\u4f20areaCode")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id"), @ApiImplicitParam(name="areaName", value="\u5730\u533a\u540d\u79f0\uff0c\u5982\uff1a\u5bcc\u9633\u533a"), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u53f7\uff0c\u5982\uff1a330111000000\uff0c2.1.0\u63a5\u53e3\u65b0\u589e\u53c2\u6570")})
    @GetMapping(value={"myKinds"})
    public Json<KindDTO> list(Long userId, String areaName, BasicParam basicParam, @RequestParam(value="areaCode", required=false) String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.newsKindService.getMyKindAndAllKind(userId, areaName, basicParam, areaCode));
    }

    @ApiOperation(value="4-05-02 \u6dfb\u52a0\u9891\u9053", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="kindId", value="\u9891\u9053id", required=true)})
    @PostMapping(value={"add"})
    public Json save(Long userId, Integer kindId) {
        if (kindId == null) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        Message message = this.newsKindService.addUserKind(userId, kindId);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u91cd\u590d\u6dfb\u52a0");
        }
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="4-05-03 \u9891\u9053\u6392\u5e8f", notes="\u5bf9\u7528\u6237\u6dfb\u52a0\u7684\u9891\u9053\u8fdb\u884c\u6392\u5e8f", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="kindIds", value="\u9891\u9053id\u6570\u7ec4", required=true), @ApiImplicitParam(name="firstOpenType", value="\u7528\u6237\u6ce8\u518c\u5b8c\u4e4b\u540e\u7b2c\u4e00\u6b21\u6253\u5f00\u5e94\u7528\u9009\u62e9\u9891\u9053:1")})
    @PostMapping(value={"resort"})
    public Json resort(Long userId, Integer[] kindIds, String firstOpenType) {
        this.newsKindService.resortUserKind(userId, kindIds, firstOpenType);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="4-05-04 \u6240\u6709\u9891\u9053", httpMethod="GET", notes="2.1.0\u65b0\u63a5\u53e3\u9700\u8981\u4f20areaCode")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaName", value="\u5730\u533a\u540d\u79f0\uff0c\u5982\uff1a\u5bcc\u9633\u533a"), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u53f7\uff0c\u5982\uff1a330111000000\uff0c2.1.0\u63a5\u53e3\u65b0\u589e\u53c2\u6570")})
    @GetMapping(value={"newsKind"})
    public Json<List<NewsKind>> listAll(@RequestParam(value="areaCode", required=false) String areaCode, String areaName, BasicParam basicParam) {
        List allKinds = this.newsKindService.selectAll(basicParam, areaName, areaCode);
        allKinds.removeIf(newsKind -> newsKind.getIsFix() == 1);
        return ResultUtil.genSuccessResult((Object)allKinds);
    }
}

