/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.ReplenishmentDTO;
import com.bxm.localnews.news.param.NewsShieldParam;
import com.bxm.localnews.news.service.MixRecommendService;
import com.bxm.localnews.news.service.NewsShieldService;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-11 \u6df7\u5408\u5185\u5bb9\u63a8\u8350\u5e93\u76f8\u5173\u63a5\u53e3"}, description="\u6df7\u5408\u5185\u5bb9\u63a8\u8350\u5e93\u4fe1\u606f")
@RestController
public class MixRecommendController {
    private final MixRecommendService mixRecommendService;
    private final NewsShieldService newsShieldService;

    @ApiOperation(value="4-11-01 \u83b7\u5f97\u63a8\u8350\u6c60\u4e2d\u7684\u6700\u524d\u7684n\u6761[\u65b0\u95fb]\u6216\u8005[\u5e16\u5b50]\u7528\u4e8e\u5206\u4eab\u9875\u8f6e\u64ad", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=true), @ApiImplicitParam(name="type", value="\u5206\u4eab\u9875\u7c7b\u578b\uff081:\u65b0\u95fb 2:\u5c0f\u89c6\u9891 3:\u5e16\u5b50\uff09", required=true), @ApiImplicitParam(name="size", value="\u60f3\u8981\u83b7\u53d6\u7684\u6761\u6570", required=true)})
    @GetMapping(value={"/api/mix/carousel"})
    public Json<List<ReplenishmentDTO>> listRecommend(@RequestParam(value="userId", required=false) Long userId, @RequestParam(value="areaCode", required=false) String areaCode, @RequestParam(value="type", required=true) Byte type, @RequestParam(value="size", required=true) Integer size) {
        List result = this.mixRecommendService.listRecommend(userId, areaCode, type, size);
        return ResultUtil.genSuccessResult((Object)result);
    }

    @ApiOperation(value="4-11-02 \u83b7\u5f97\u70ed\u95e8[\u5e16\u5b50]\u6216\u8005[\u65b0\u95fb]\u7528\u4e8e\u8865\u7b7e\u6216\u8005\u8f6c\u53d1", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801", required=true), @ApiImplicitParam(name="type", value="\u7c7b\u578b 1:\u4efb\u52a1\u70b9\u8f6c\u53d1\u83b7\u53d6\u63a8\u8350\u6c60\u6587\u7ae0\u5206\u4eab 3:\u8865\u7b7e\u5206\u4eab 5.\u4eca\u65e5\u70ed\u95fb", required=false)})
    @GetMapping(value={"/api/forum/hot"})
    public Json<ReplenishmentDTO> recommend(@RequestParam(value="userId", required=true) Long userId, @RequestParam(value="areaCode", required=true) String areaCode, @RequestParam(value="type", required=false) Byte type) {
        if (null == userId) {
            return ResultUtil.genFailedResult((String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f!");
        }
        return ResultUtil.genSuccessResult((Object)this.mixRecommendService.getHotPostOrNews(userId, areaCode, type));
    }

    @ApiOperation(value="4-11-03 \u5c4f\u853d[\u65b0\u95fb]\u6216\u8005[\u5e16\u5b50]", httpMethod="POST")
    @PostMapping(value={"{version}/news/mix/shield"})
    @ApiVersion(value=1)
    public Json shield(@RequestBody @Valid NewsShieldParam newsShieldParam) {
        this.newsShieldService.save(newsShieldParam);
        return ResultUtil.genSuccessResult();
    }

    @Autowired
    public MixRecommendController(MixRecommendService mixRecommendService, NewsShieldService newsShieldService) {
        this.mixRecommendService = mixRecommendService;
        this.newsShieldService = newsShieldService;
    }
}

