package com.bxm.localnews.news.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@ConfigurationProperties("news.config")
@Data
public class NewsProperties {

    /**
     * 推荐栏目
     */
    private int recommendKindId;

    /**
     * 全民微课堂
     */
    private int knowledgeKindId;

    /**
     * 小视频
     */
    private int videoKindId;

    /**
     * 专门为IOS提包设置的默认频道
     */
    private List<Integer> propertyKindIds;

    /**
     * 阅读文章奖励次数
     */
    private int readNumAwardCount;

    /**
     * 阅读新闻奖励的时间差(防止连续阅读奖励)
     */
    private String awardTimeLag;

    /**
     * 给与金币的奖励条件（是否阅读到文章底部,1:否，2：是）
     */
    private String readBottom;

    /**
     * 给与金币的奖励条件（是否必须展示广告位1:否，2：是）
     */
    private String showAdvert;

    /**
     * 给与金币的奖励条件（是否达到最低的阅读时间）
     */
    private int viewTime;

    private String tabType;

    private int shareNumAwardCount;

    /**
     * 获得的金币上限
     */
    private int goldPerDay;

    /**
     * 默认分享图
     */
    private String defaultShareCover;
}
