package com.bxm.localnews.news.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;


/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块} 业务类型： biz:业务 config:配置
 */
public class RedisConfig {


    /**
     * ====================================================================== news 模块相关缓存键值 用户阅读推荐新闻获得奖励的次数
     */
    public static KeyGenerator RECOMMEND_NEWS_READ = DefaultKeyGenerator.build("news", "recommendNewsRead");

    /**
     * 用户阅读新闻获得奖励的次数
     */
    public static KeyGenerator NEWS_READ = DefaultKeyGenerator.build("news", "readnews");

    /**
     * 新闻类型缓存
     */
    public static KeyGenerator NEWS_KIND = DefaultKeyGenerator.build("news", "cache", "newskind");

    /**
     * 新闻静态数据存放
     */
    public static KeyGenerator NEWS_STATISTIC = DefaultKeyGenerator.build("news", "statistic");

    /**
     * 推荐给个人用户的小视频缓存，30分钟有效期
     */
    public static KeyGenerator VIDEO_RECOMMEND = DefaultKeyGenerator.build("video", "usercache");

    /**
     * 推荐给个人用户的小视频缓存，2小时有效期
     */
    public static KeyGenerator NEWS_RECOMMEND = DefaultKeyGenerator.build("news", "usercache");

    /**
     * 用户推荐新闻间隔
     */
    public static KeyGenerator NEWS_RECOMMEND_INTERVAL = DefaultKeyGenerator.build("news", "recommend",
            "interval");

    /**
     * 用户频道缓存
     */
    public static KeyGenerator NEWS_USER_KIND = DefaultKeyGenerator.build("news", "kind", "user_list");

    /**
     * 用户频道set缓存
     */
    public static KeyGenerator NEWS_USER_KIND_SET = DefaultKeyGenerator.build("news", "kind", "user_set");

    /**
     * 小视频队列
     */
    public static KeyGenerator VIDEO_QUEUE = DefaultKeyGenerator.build("video", "queue");

    /**
     * 新闻队列
     */
    public static KeyGenerator NEWS_QUEUE = DefaultKeyGenerator.build("news", "queue");

    /**
     * 首页置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_LIST = DefaultKeyGenerator.build("news", "top");

    /**
     * 首页区域性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_AREA_LIST = DefaultKeyGenerator.build("news", "top");

    /**
     * 首页全国性置顶列表缓存key
     */
    public static KeyGenerator TOP_NEW_OF_WHOLE_COUNTRY_LIST = DefaultKeyGenerator.build("news", "top",
            "wholeCountry");

    /**
     * 用户当日分享新闻记录 ,有效期:当天
     */
    public static KeyGenerator USER_SHARE_NEWS_RECORD = DefaultKeyGenerator.build("activity", "task",
            "usersharenews");

    /**
     * 帖子id生成规则
     */
    public static KeyGenerator SEQ_POST_ID = DefaultKeyGenerator.build("seq", "post", "id");

    /**
     * 用户首次进入推广地区
     */
    public static KeyGenerator FIRST_ENTER_PROMOTION_AREA = DefaultKeyGenerator.build("news", "user", "fistPromotion");

    /**
     * 论坛帖子推荐相关模块
     */
    public static KeyGenerator FORUM_RECOMMENDED = DefaultKeyGenerator.build("forum", "recommended");

    /**
     * 论坛帖子相关模块
     */
    public static KeyGenerator FORUM_INFO = DefaultKeyGenerator.build("forum","info");

    /**
     * 用户当天点赞帖子次数
     */
    public static KeyGenerator FORUMPOST_LIEK_TIME= DefaultKeyGenerator.build("activity","task","forumpostLikeTime");

    /**
     * 社区版块缓存
     */
    public static KeyGenerator FORUM = DefaultKeyGenerator.build("forum", "cache", "forum");

    /**
     * 社区话题缓存
     */
    public static KeyGenerator TOPIC = DefaultKeyGenerator.build("forum", "cache", "topic");
    /**
     * 新建奖励帖子轮播信息
     */
    public static KeyGenerator FORUM_POST_REWARD_LIST = DefaultKeyGenerator.build("forum", "post", "reward_list");

}
