package com.bxm.localnews.news.factory.impl;

import org.apache.commons.lang3.StringUtils;

public class EmojiFactory {
	/**
	 * 过滤emoji 或者 其他非文字类型的字符
	 * @param codePoint
	 * @return  ture 文字 ,fase 非文字类型
	 */
	private static boolean isNormalCharacter(char codePoint) {
		return (codePoint == 0x0)
				|| (codePoint == 0x9)
				|| (codePoint == 0xA)
				|| (codePoint == 0xD)
				|| ((codePoint >= 0x20) && (codePoint <= 0xD7FF))
				|| ((codePoint >= 0xE000) && (codePoint <= 0xFFFD))
				|| ((codePoint >= 0x10000) && (codePoint <= 0x10FFFF));
	}

	/**
	 * 过滤emoji 或者 其他非文字类型的字符
	 *
	 * @param source 原字符串
	 * @return 过滤后的字符串
	 */
	public static String filterEmoji(String source,int length) {
		if (StringUtils.isBlank(source)) {
			return source;
		}
		StringBuilder buf = new StringBuilder();
		int j = 0;
		int len = source.length();
		for (int i = 0; i < len; i++) {
			if (j < length){
				char codePoint = source.charAt(i);
				buf.append(codePoint);
				if (isNormalCharacter(codePoint)) {
					++j;
				}
			}else{
				break;
			}
		}
		return buf.toString();
	}

}
