package com.bxm.localnews.news.factory.impl;

import com.bxm.newidea.component.tools.HtmlContentUtils;

import com.vdurmont.emoji.EmojiParser;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhaoyadong 2019/7/4 15:43
 * @desc
 */
public class ExtendFactory {

    public static String getContent(String title, String originContent) {
        String result;
        if (StringUtils.isNotBlank(title)) {
            if (EmojiParser.removeAllEmojis(title).length() >= 10) {
                title = EmojiFactory.filterEmoji(title,10) + "...";
            }
            result = title;
        } else {
            String content = HtmlContentUtils.delHtmlTags(originContent);
            if (StringUtils.isNotBlank(content) && EmojiParser.removeAllEmojis(title).length() >= 10) {
                content = EmojiFactory.filterEmoji(content,10) + "...";
            }
            result = content;
        }
        return result;
    }

    public static String getPostContent(String title, String textField) {
        String result;
        if (StringUtils.isNotBlank(title)) {
            if (EmojiParser.removeAllEmojis(title).length() >= 10) {
                title = EmojiFactory.filterEmoji(title,10) + "...";
            }
            result = title;
        } else {
            String content = textField.replace("&nbsp;","");;
            if (StringUtils.isNotBlank(content)){
                if ( EmojiParser.removeAllEmojis(content).length() >= 10) {
                    content = EmojiFactory.filterEmoji(content,10) + "...";
                }
            }
            result = content;
        }
        return result;
    }

    public static String getSharePostContent(String title, String textField) {
        String result;
        if (StringUtils.isNotBlank(title)) {
            result = title;
        } else {
            String content = textField.replace("&nbsp;","");
            if (StringUtils.isNotBlank(content)){
                if (EmojiParser.removeAllEmojis(content).length() >= 25) {
                    content = EmojiFactory.filterEmoji(content,25) + "...";
                }
            }
            result = content;
        }
        return result;
    }

    public static String getTitle(String title, String textField) {
        String result;
        if (StringUtils.isNotBlank(title)) {
            result = title;
        } else {
            String content = textField.replace("&nbsp;","");
            if (StringUtils.isNotBlank(content)){
                if (EmojiParser.removeAllEmojis(content).length() >= 50) {
                    content =EmojiFactory.filterEmoji(content,50);
                }
            }
            result = content;
        }
        return result;
    }
}
