package com.bxm.localnews.news.config;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@ConfigurationProperties("forum.config")
@Data
public class ForumProperties {

    /**
     * 爆料有奖页面地址
     */
    private String publishRewardUrl;

    /**
     * 默认推荐语
     */
    private String defaultRecommendContent;

    /**
     * 帖子定时统计钉钉群机器人webhook地址
     */
    private String calculatePostWebhook;

    /**
     * 小纸条话题id
     */
    private Long noteTopicId;

    /**
     * 用户每日可发布次数
     */
    private Integer userPublishNum;

    /**
     * 小纸条分享图
     */
    private String noteShareImg;

    /**
     * 待审核帖子站外审核uv限制数
     * 到达限制后显示[禁止访问]
     */
    private Integer h5LimitNum;

    /**
     * 小纸条引导文案
     */
    private String noteGuidance = "你可以写这样的纸条：\n" +
            "\n" +
            "今天天气不错有没有人出去爬山\n" +
            "\n" +
            "小孩子要入学需要准备哪些手续\n" +
            "\n" +
            "想一份离家近的工作\n" +
            "\n" +
            "\n" +
            "\n" +
            "写好的纸条会在广德人列表展示哦";

    /**
     * 收徒赚钱的推荐帖子数量
     * 3.7.0版本新增
     * 默认20
     */
    private Integer topPostNum = 20;

    /**
     * 教育用户的帖子id集合
     */
    private List<Long> teachIds = Lists.newArrayList();

    /**
     * 教育用户的帖子所在的角标
     */
    private Integer forumTeachIndex = 1;

    private Integer postRewardCashMax = 200;

    private Integer postRewardCashMin = 0;

    /**
     * 帖子评论列表最大的查询天数
     */
    private Integer maxReplyQueryDay = 7;

    /**
     * 3.9.0需求
     *
     * 热门评论最多显示条数
     */
    private Integer hotReplyViewNum = 5;

    /**
     * 3.9.0 需求
     *
     * 点赞多少也算热门评论   （热门评论的一个计算方式）
     */
    private Integer hotReplyForLikeCountNum = 2;

    /**
     * 热门帖子显示条数
     */
    private Integer hotForumLimitNum = 20;

    /**
     * 取最近N天的热门帖子
     */
    private Integer hotForumDaysLimit = 7;

    /**
     * 本地圈头部显示热门贴数量
     */
    private Integer hotForumTopViewNum = 5;

    private String hotForumButtonText = "分享一周热门给好友";

    /**
     * 3.10.0  本地圈关注帖子列表顶部引动文案
     */
    private String guideToFollowedText = "去认识更过有去的朋友吧！";

    /**
     * 关注帖子列表顶部显示引导语的判断人数
     */
    private Integer guideShowFollowedNum = 30;

    /**
     * 热门帖子热度值重计算依据
     */
    private String hotForumDate;

    private String defaultGuidePopText = "跟{areaname}朋友们聊聊家常\n晒晒身边事，交交朋友";
}
