package com.bxm.localnews.news.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 本地圈面包块配置
 *
 * @author wzy
 * @version 1.0
 * @date 2020/9/22 5:31 下午
 */
@Component
@ConfigurationProperties("forum.config.crumbs")
@Data
public class LocalCrumbsProperties {

    /**
     * 话题广场面包块标题
     */
    private String topicSquareTitle = "话题广场";

    /**
     * 同城交友面包块标题
     */
    private String cityFriendsTitle = "同城交友";

    /**
     * 话题广场面包块背景图片
     */
    private String topicSquareImgUrl = "https://mtest.wstong.com/localnews_test/png/20201012/H8UKWHWUXWQJNYXZ24PELAPYBYWT3FZ8N36GKD.png";

    /**
     * 同城交友面包块背景图片
     */
    private String cityFriendsImgUrl = "https://mtest.wstong.com/localnews_test/png/20201012/H8UKWHWUXWQJNYXZ24PELAPYBYWT3A6TP36GKE.png";


    /**
     * 话题广场跳转地址
     */
    private String topicSquareJumpUrl = "wst://community/topicList";

    /**
     * 同城交友跳转地址
     */
    private String cityFriendJumpUrl = "wst://local/localList";
}