package com.bxm.localnews.news.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@ConfigurationProperties("news.config")
@Data
public class NewsProperties {

    /**
     * 推荐栏目
     */
    private int recommendKindId;

    /**
     * 全民微课堂
     */
    private int knowledgeKindId;

    /**
     * 小视频
     */
    private int videoKindId;

    /**
     * 专门为IOS提包设置的默认频道
     */
    private List<Integer> propertyKindIds;

    /**
     * 阅读文章奖励次数
     */
    private int readNumAwardCount;

    /**
     * 阅读新闻奖励的时间差(防止连续阅读奖励)
     */
    private String awardTimeLag;

    /**
     * 给与金币的奖励条件（是否阅读到文章底部,1:否，2：是）
     */
    private String readBottom;

    /**
     * 给与金币的奖励条件（是否必须展示广告位1:否，2：是）
     */
    private String showAdvert;

    /**
     * 给与金币的奖励条件（是否达到最低的阅读时间）
     */
    private int viewTime;

    private String tabType;

    private int shareNumAwardCount;

    /**
     * 获得的金币上限
     */
    private int goldPerDay;

    /**
     * 默认分享图
     */
    private String defaultShareCover;

    /**
     * IM中默认分享图
     */
    private String defaultImShareImg;

    /**
     * 是否在新闻首页插入小视频
     */
    private Boolean includeVideo = false;

    /**
     * 商家下架的情况下，是否仍然强制显示商家信息
     */
    private Boolean forceShowMerchant = true;

    /**
     * 敏感词屏蔽时，是否跳过停断词
     */
    private Boolean skipStopWord = true;

    /**
     * 3.9.0
     *
     * 本地圈引导发帖弹窗开关
     */
    private Boolean forumGuidePopFlag = true;

    /**
     * 3.9.0
     * 本地圈引导弹窗主标题
     */
    private String forumGuidePopTitle = "发身边事";

    /**
     * 3.9.0
     * 本地圈引导弹窗副标题
     */
    private String forumGuidePopSubTitle = "每天最高领{content}元";

    /**
     * 3.9.0
     * 本地圈引导弹窗填充内容
     */
    private String forumGuidePopContent = "100";

    /**
     * 热帖列表分享地址
     */
    private String hotForumShareUrl = "shareNewsTop.html";

    private String shareImgUrl = "http://bxm-news.oss-cn-hangzhou.aliyuncs.com/bxm-news/png/20201130/%E7%83%AD%E9%97%A8.png";

    /**
     * 3.10.0 话题下帖子数取值范围 （信息流中插入话题时）
     */
    private int topicForumLimit = 3;

    /**
     *
     * 3.10.0 推荐话题权重取值范围
     *
     */
    private int recommendTopicOrderNum = 6;

    /**
     * 3.10.0 热门榜单底部分享按钮文案
     */
    private String shareButtonText = "分享一周热门给好友";

    /**
     * 话题一次性弹窗内容
     */
    private String topicPopInfo;
}
