package com.bxm.localnews.news.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author gonzo
 * @date 2020-10-28 20:58
 **/
@Component
@ConfigurationProperties("news.config.post-count")
@Data
public class PostCountProperties {

    /**
     * 默认的本地用户数初始值
     */
    private BigDecimal defaultLocalUserNum = BigDecimal.valueOf(20000);

    /**
     * 默认的全国用户初始值
     */
    private BigDecimal defaultGlobalUserNum = BigDecimal.valueOf(100000);

    /**
     * 最小的普通帖子初始基数比例
     */
    private Integer minDefaultInitialBasicNumRate = 5;

    /**
     * 最大的普通帖子初始基数比例
     */
    private Integer maxDefaultInitialBasicNumRate = 20;

    /**
     * 最小的推荐帖子初始基数比例
     */
    private Integer minRecommendDefaultInitialBasicNumRate = 15;

    /**
     * 最大的推荐帖子初始基数比例
     */
    private Integer maxRecommendDefaultInitialBasicNumRate = 25;
}
