package com.bxm.localnews.news.enums;

/**
 * 帖子状态枚举类
 *
 * @author stephen
 */
public enum PostStatusEnum {

    NORMAL((byte) 1, "正常显示"),
    APPROVING((byte) 2, "审核中"),
    REJECTED((byte) 3, "被拒绝"),
    USER_DELETE((byte) 4, "用户删除"),
    SELF((byte) 5, "仅楼主可见"),
    BLOCKED((byte) 6, "本地圈屏蔽"),
    OPERATOR_DELETE((byte) 7, "运营删除"),
    ;

    PostStatusEnum(byte code, String name) {
        this.code = code;
        this.name = name;
    }

    private byte code;

    private String name;

    public byte getCode() {
        return code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
