package com.bxm.localnews.news.event;


import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 新闻用户评论事件
 *
 * @author liujia
 * @date 2020-07-16 19:17
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class CommentActionEvent extends UserActionEvent {
    private final UserActionEnum action = UserActionEnum.COMMENT;

    /**
     * 评论目标
     */
    private Long targetId;

    /**
     * 评论事件
     */
    private Date lastCommentTime;
}
