package com.bxm.localnews.news.event;

import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 用户发布小纸条
 *
 * @author liujia
 * @date 2020-07-16 19:25
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class NoteActionEvent extends UserActionEvent {

    private final UserActionEnum action = UserActionEnum.NOTE;

    /**
     * 用户发布的小纸条ID
     */
    private Long lastNoteId;

    /**
     * 发布小纸条的时间
     */
    private Date lastNoteTime;
}
