package com.bxm.localnews.news.event;

import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.experimental.Accessors;

/**
 * 用户行为参数
 *
 * @author liujia
 * @date 2020-07-16 14:46
 **/
@Accessors(chain = true)
public class UserActionEvent {

    /**
     * 用户行为，子类进行覆盖
     */
    private UserActionEnum action;

    /**
     * 所属用户ID
     */
    private Long userId;

    public UserActionEnum getAction() {
        return action;
    }

    final void setAction(UserActionEnum action) {
        this.action = action;
    }

    public Long getUserId() {
        return userId;
    }

    public UserActionEvent setUserId(Long userId) {
        this.userId = userId;
        return this;
    }
}
