package com.bxm.localnews.news.event;

import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 视频屏蔽事件
 *
 * @author liujia
 * @date 2020-07-16 19:58
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class VideoBlackActionEvent extends UserActionEvent {
    private final UserActionEnum action = UserActionEnum.VIDEO_BLACK;

    /**
     * 屏蔽的视频ID
     */
    private Long videoId;

    /**
     * 屏蔽类型
     */
    private Integer type;

    /**
     * 屏蔽原因
     */
    private String reason;
}
