package com.bxm.localnews.news.event;

import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户发起分享
 *
 * @author liujia
 * @date 2020-07-16 19:30
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class VideoShareActionEvent extends UserActionEvent {
    private final UserActionEnum action = UserActionEnum.VIDEO_SHARE;

    /**
     * 分享的目标内容
     */
    private Long targetId;

    private Byte type;
}