package com.bxm.localnews.news.event;

import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 内容浏览事件
 *
 * @author liujia
 * @date 2020-07-16 19:41
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class ViewActionEvent extends UserActionEvent {

    private final UserActionEnum action = UserActionEnum.VIEW;

    /**
     * 浏览目标ID
     */
    private Long targetId;
}
