package com.bxm.localnews.news.util;

import com.bxm.newidea.component.tools.StringUtils;

public class VersionUtils {

    /**
     * 比较版本号，-1:curVersion小于version 0:curVersion等于version 1:curVersion大于version
     *
     * @param curVersion
     * @param version
     * @return
     */
    public static int isHighVersion(String curVersion, String version) {
        //如果服务端版本高于客户端版本
        if (curVersion == null && version != null) {
            return -1;
        }
        //如果客户端版本高于服务端版本
        if (curVersion != null && version == null) {
            return 1;
        }
        //如果版本一致
        if (StringUtils.equals(curVersion, version)) {
            return 0;
        }
        //进行版本比较
        return StringUtils.compareVersion(curVersion, version);
    }

}
