/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.factory.impl;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UrlFactory
implements IUrlFactory {
    @Autowired
    private BizConfigProperties bizConfigProperties;
    @Autowired
    private DomainIntegrationService domainIntegrationService;

    @Override
    public String getAppUrl(UrlCategoryEnum urlCategoryEnum, UrlTypeEnum urlTypeEnum, Long id, Long userId) {
        String outSideShareBaseUrl = this.domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.CONTENT_VIEW);
        if (UrlCategoryEnum.NEWS.equals((Object)urlCategoryEnum)) {
            if (UrlTypeEnum.DETAIL.equals((Object)urlTypeEnum)) {
                if (userId == null) {
                    return StringUtils.join((Object[])new Serializable[]{outSideShareBaseUrl, "/newsDetail.html?", "newsId=", id, "&type=", Integer.valueOf(1)});
                }
                return StringUtils.join((Object[])new Serializable[]{outSideShareBaseUrl, "/newsDetail.html?", "newsId=", id, "&userId=", userId, "&type=", Integer.valueOf(1)});
            }
            if (UrlTypeEnum.SHARE.equals((Object)urlTypeEnum)) {
                if (userId == null) {
                    return StringUtils.join((Object[])new Serializable[]{outSideShareBaseUrl, "/shareNewsDetail.html?", "newsId=", id, "&type=", Integer.valueOf(2)});
                }
                return StringUtils.join((Object[])new Serializable[]{outSideShareBaseUrl, "/shareNewsDetail.html?", "newsId=", id, "&userId=", userId, "&type=", Integer.valueOf(2)});
            }
        } else if (UrlCategoryEnum.FORUM.equals((Object)urlCategoryEnum)) {
            if (UrlTypeEnum.BLOCK.equals((Object)urlTypeEnum)) {
                return StringUtils.join((Object[])new Serializable[]{outSideShareBaseUrl, "/shareBlockDetail.html?userId=", userId, "&id=", id});
            }
            if (UrlTypeEnum.TOPIC.equals((Object)urlTypeEnum)) {
                return StringUtils.join((Object[])new Serializable[]{outSideShareBaseUrl, "/shareTopicDetail.html?userId=", userId, "&id=", id});
            }
            if (UrlTypeEnum.SHARE.equals((Object)urlTypeEnum)) {
                return StringUtils.join((Object[])new Serializable[]{outSideShareBaseUrl, "/shareInvitationDetail.html?userId=", userId, "&id=", id});
            }
        }
        return null;
    }

    @Override
    public String getAppletUrl(UrlPositionEnum urlPositionEnum, Long id, Long userId) {
        switch (urlPositionEnum) {
            case BLOCK: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=block&id=" + id + "&isShare=1&uid=" + userId;
            }
            case TOPIC: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=topic&id=" + id + "&isShare=1&uid=" + userId;
            }
            case POST: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=post&id=" + id + "&isShare=1&uid=" + userId;
            }
            case NEWS: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=news&id=" + id + "&isShare=1&uid=" + userId;
            }
            case MANLL_HOME: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=manllHome&id=" + id + "&isShare=1&uid=" + userId;
            }
        }
        return null;
    }
}

