package com.bxm.localnews.news.config;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 通用的业务配置，具体模块的配置需要在对应的模块内创建properties和特定的前缀接收
 *
 * @author liujia 2018/7/26 16:45
 */
@Data
@Component
@ConfigurationProperties("common.config")
public class BizConfigProperties {

    /**
     * api签名加密密钥
     */
    private String apiSignKey;

    /**
     * 当前环节（遗留系统需要此值）
     */
    private int env;

    /**
     * 允许访问的请求来源，通过“,”分割
     */
    private String allowOrigins;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 临时文件存储目录
     */
    private String tempDir;

    /**
     * 是否启用方法签名
     */
    private Boolean enableRequestSign;

    /**
     * 数据埋点根路径
     */
    private String buryPointHost;

    /**
     * APPLET访问根路径
     */
    private String appletServerHost;

    /**
     * 应用图标地址
     */
    private String appIconUrl;

    /**
     * 白名单账号（用于app提包时提供的特殊账号）
     */
    private List<String> whiteList = Lists.newArrayList();

    /**
     * 安卓限制展示渠道列表(不同的渠道需要过包时进行敏感功能隐藏)
     */
    private List<String> disableAndroidChannel = Lists.newArrayList();

    /**
     * 是否开启上线检查开关（1：提包状态（敏感信息隐藏）,2:正常显示）
     */
    private String switchType;

    /**
     * 区域编码
     */
    private String locationCode;

    /**
     * 区域名称
     */
    private String locationName;

    /**
     * 业务打点日志的请求路径
     */
    private String bizLogUrl;

    /**
     * 是否启用小程序审核
     */
    private Boolean appletReviewEnable;

    private Boolean enablePostTagParse = false;
}
