package com.bxm.localnews.news.config;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@ConfigurationProperties("forum.config")
@Data
public class ForumProperties {

    /**
     * 爆料有奖页面地址
     */
    private String publishRewardUrl;

    /**
     * 默认推荐语
     */
    private String defaultRecommendContent;

    /**
     * 帖子定时统计钉钉群机器人webhook地址
     */
    private String calculatePostWebhook;

    /**
     * 小纸条话题id
     */
    private Long noteTopicId;

    /**
     * 用户每日可发布次数
     */
    private Integer userPublishNum;

    /**
     * 小纸条分享图
     */
    private String noteShareImg;

    /**
     * 待审核帖子站外审核uv限制数
     * 到达限制后显示[禁止访问]
     */
    private Integer h5LimitNum;

    /**
     * 小纸条引导文案
     */
    private String noteGuidance = "你可以写这样的纸条：\n" +
            "\n" +
            "今天天气不错有没有人出去爬山\n" +
            "\n" +
            "小孩子要入学需要准备哪些手续\n" +
            "\n" +
            "想一份离家近的工作\n" +
            "\n" +
            "\n" +
            "\n" +
            "写好的纸条会在广德人列表展示哦";

    /**
     * 收徒赚钱的推荐帖子数量
     * 3.7.0版本新增
     * 默认20
     */
    private Integer topPostNum = 20;

    /**
     * 教育用户的帖子id集合
     */
    private List<Long> teachIds = Lists.newArrayList();

    /**
     * 教育用户的帖子所在的角标
     */
    private Integer forumTeachIndex = 1;

    private Integer postRewardCashMax = 200;

    private Integer postRewardCashMin = 0;

}
