package com.bxm.localnews.news.event;

import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author liujia
 * @date 2020-07-16 19:44
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class CollectActionEvent extends UserActionEvent {

    private final UserActionEnum action = UserActionEnum.COLLECT;

    /**
     * 收藏状态，true：收藏，false：取消收藏
     */
    private Boolean state;

    /**
     * 收藏的目标内容
     */
    private Long targetId;

}
