package com.bxm.localnews.news.event;

import com.bxm.localnews.news.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 视频评论
 *
 * @author liujia
 * @date 2020-07-18 17:54
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class VideoCommentActionEvent extends UserActionEvent {
    private final UserActionEnum action = UserActionEnum.VIDEO_COMMENT;

    /**
     * 评论目标
     */
    private Long targetId;

    /**
     * 评论事件
     */
    private Date lastCommentTime;
}
