package com.bxm.localnews.news.factory.impl;

import com.vdurmont.emoji.EmojiParser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;

public class EmojiFactory {


	/**
	 * 过滤emoji 或者 其他非文字类型的字符
	 *
	 * @param source 原字符串
	 * @return 过滤后的字符串
	 */
	public static String filterEmoji(String source,int length) {
		if (StringUtils.isBlank(source)) {
			return source;
		}
		source = EmojiParser.removeAllEmojis(source);
		if (source.length() >= length ){
			source = source.substring(0,length);
		}
		List<String> strings = EmojiParser.extractEmojis(source);
		StringBuilder result = new StringBuilder();
		result.append(source);
		if (!CollectionUtils.isEmpty(strings)){
			strings.forEach(e->{
				result.append(e);
			});
		}
		return result.toString();
	}

}
