package com.bxm.localnews.news.factory.impl;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;

import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static org.apache.commons.lang3.StringUtils.join;

/**
 * @author shentao
 */
@Component
public class UrlFactory implements IUrlFactory {

    @Autowired
    private BizConfigProperties bizConfigProperties;

    @Autowired
    private DomainIntegrationService domainIntegrationService;

    @Override
    public String getAppUrl(UrlCategoryEnum urlCategoryEnum, UrlTypeEnum urlTypeEnum, Long id, Long userId) {
        // 获取站外需要js api授权的落地页域名
        String outSideShareBaseUrl = domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.WX_JS_VIEW);

        if (UrlCategoryEnum.NEWS.equals(urlCategoryEnum)) {
            if (UrlTypeEnum.DETAIL.equals(urlTypeEnum)) {
                if (userId == null) {
                    return join(outSideShareBaseUrl, "/newsDetail.html?", "newsId=", id, "&type=", 1);
                } else {
                    return join(outSideShareBaseUrl, "/newsDetail.html?", "newsId=", id, "&userId=", userId, "&type=", 1);
                }
            } else if (UrlTypeEnum.SHARE.equals(urlTypeEnum)) {
                if (userId == null) {
                    return join(outSideShareBaseUrl, "/shareNewsDetail.html?", "newsId=", id, "&type=", 2);
                } else {
                    return join(outSideShareBaseUrl, "/shareNewsDetail.html?", "newsId=", id, "&userId=", userId, "&type=", 2);
                }
            }
        } else if (UrlCategoryEnum.FORUM.equals(urlCategoryEnum)) {
            if (UrlTypeEnum.BLOCK.equals(urlTypeEnum)) {
                return join(outSideShareBaseUrl, "/shareBlockDetail.html?userId=", userId, "&id=", id);
            } else if (UrlTypeEnum.TOPIC.equals(urlTypeEnum)) {
                return join(outSideShareBaseUrl, "/shareTopicDetail.html?userId=", userId, "&id=", id);
            }else if (UrlTypeEnum.SHARE.equals(urlTypeEnum)) {
                return join(outSideShareBaseUrl, "/shareInvitationDetail.html?userId=", userId, "&id=", id);
            }
        }
        return null;
    }

    @Override
    public String getAppletUrl(UrlPositionEnum urlPositionEnum, Long id, Long userId) {
        switch (urlPositionEnum) {
            case BLOCK:
                return bizConfigProperties.getAppletServerHost() + "?tp=block&id=" + id + "&isShare=1&uid=" + userId;
            case TOPIC:
                return bizConfigProperties.getAppletServerHost() + "?tp=topic&id=" + id + "&isShare=1&uid=" + userId;
            case POST:
                return bizConfigProperties.getAppletServerHost() + "?tp=post&id=" + id + "&isShare=1&uid=" + userId;
            case NEWS:
                return bizConfigProperties.getAppletServerHost() + "?tp=news&id=" + id + "&isShare=1&uid=" + userId;
            case MANLL_HOME:
                return bizConfigProperties.getAppletServerHost() + "?tp=manllHome&id=" + id + "&isShare=1&uid=" + userId;
            default:
                return null;
        }
    }
}
