package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.dto.ForumPostDTO;
import com.bxm.localnews.news.param.HomeRecommendParam;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MixedRecommendPool;
import com.bxm.localnews.news.vo.NewsVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface MixedRecommendPoolMapper {

    int deleteByPrimaryKey(Long id);

    int insert(MixedRecommendPool record);

    int insertSelective(MixedRecommendPool record);

    MixedRecommendPool selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(MixedRecommendPool record);

    int updateByPrimaryKey(MixedRecommendPool record);

    MixedRecommendPool selectHotRecommend(@Param("areaCode") String areaCode,@Param("userId")Long userId);

    int deleteExpiredMixRecommend();

    List<Long> listPostRecommend(HomeRecommendParam homeRecommendParam);

    /**
     * 删除推荐池帖子
     * @param id
     * @return
     */
    int deleteMixRecommandPoolById(Long id);

    /**
     * 去本地或全国的爆料贴
     * @param areaCode
     * @param size
     * @return
     */
    List<ForumPostVo> selectByBrokePost(@Param("areaCode") String areaCode, @Param("size")Integer size);

    /**
     * 查询推荐库的本地新闻
     * @param areaCode
     * @param size
     * @return
     */
    List<Long> selectLocalNewsByAreaCode(@Param("areaCode")String areaCode, @Param("size")int size);
}