package com.bxm.localnews.news.domain;

import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.NewsReplyMirrorDTO;
import com.bxm.localnews.news.param.NewsReplyParam;
import com.bxm.localnews.news.vo.MyReceiveReplysVO;
import com.bxm.localnews.news.vo.NewsReply;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface NewsReplyMapper {

    /**
     * 删除用户评论，设置用户评论删除标记为1
     * 分表
     * @param id 评论ID
     * @return
     */
    int deleteByPrimaryKey(@Param("id") Long id,@Param("newsId") Long newsId,@Param("isUserDelete") Byte isUserDelete);

    /**
     * 插入新闻评论表
     */
    int insertSelective(NewsReply record);

    /**
     * 分表之后，目前在全表扫描，之后需要改
     */
    NewsReply selectByPrimaryKey(@Param("id") Long id);

    /**
     * 根据评论id和新闻id查找
     */
    NewsReply selectByPrimaryKeyAndNewsId(@Param("id") Long id,@Param("newsId") Long newsId);

    /**
     * 更新评论表中的数据
     * 1.更新互动值
     * 2.更新点赞数
     */
    int updateByPrimaryKeySelective(NewsReply record);

    /**
     * 分页
     * @param newsReplyParam
     * @return
     */
    List<NewsReplyDTO> queryByPageSize(NewsReplyParam newsReplyParam);

    /**
     * 根据小视频id查找评论进行分页
     * @param newsReplyParam
     * @return
     */
    List<NewsReplyDTO> queryVideoReplyByPageSize(NewsReplyParam newsReplyParam);

    /**
     * 暂不用
     * @param userId
     * @param page
     * @return
     */
    @Deprecated
    List<MyReceiveReplysVO> myReceiveReplys(@Param("userId") Long userId, @Param("page") MPage page);

    /**
     * 查找根评论下的回复
     * @param rootId
     * @param newsId
     * @return
     */
    List<NewsReplyMirrorDTO> selectSubReplyList(@Param("rootId")Long rootId,@Param("newsId")Long newsId);

    /**
     * 定时任务相关：扫描全表新闻评论，判断是否时间小于目前时间且状态为待展示
     * @return
     */
    List<NewsReply> selectByTime();

    /**
     * 用户更改信息相关：扫描全表新闻评论，更新用户评论的头像和昵称
     * @return
     */
    List<NewsReply> selectByUser(@Param("userId") Long userId);

    /**
     * 用户更改信息相关：扫描全表新闻评论，更新用户评论的头像和昵称
     * @return
     */
    List<NewsReply> selectByParentUser(@Param("userId") Long userId);

    int updateUserInfo(NewsReply newsReply);

    int updateParentUserInfo(NewsReply newsReply);

    /**
     * 定时任务相关：更新评论的状态为已展示
     * @param newsId
     * @param id
     */
    int updateStatus(@Param("newsId") Long newsId,@Param("id") Long id);

    /**
     * 获得帖子的前五条评论信息
     * @param newsId
     * @return
     */
    List<NewsReply> selectPostReplyByNewsIdOrderByAddTime(@Param("newsId")Long newsId);

    List<Long> selectPostIdByTime(Date date);

    /**
     * 批量查询所有 list中所有自评论
     * @param list
     * @param newsId
     * @return
     */
    List<NewsReplyMirrorDTO> selectSubReplyLists(@Param("list")List<Long> list, @Param("newsId")Long newsId);

    /**
     * 查询当前用户是否对新闻点赞
     * @param newsId 新闻id
     * @param userId 用户id
     * @param rootId 根评论id
     * @return
     */
    List<Long> selectReplyLike(@Param("newsId")Long newsId , @Param("userId")Long userId, @Param("rootId") Long rootId);

    Integer calcReplyNum(@Param("newsId") Long postId);

    int deleteSubReply(@Param("rootId")Long rootId, @Param("newsId")Long newsId);

    int selectCountByNewsId(Long newsId);

    /**
     * 根据帖子id获取评论头像
     *
     * @param newsId
     * @return
     */
    List<String> getReplyHeadImgList(@Param("newsId") Long newsId);

    /**
     * 更新评论的用户信息
     * @param record
     * @return
     */
    int updateReplyUserInfo(NewsReply record);

    /**
     *
     * @param tableName
     * @return
     */
    List<NewsReply> selectByUserIdIsZero(@Param("tableName")  String tableName);

    /**
     * 删除多余数据
     * @return
     */
    int deleteNewsReply();

	/**
	 * 获取模拟评论数量
	 * @param newReportId
	 * @param size
	 * @return
	 */
	List<String> selectRandomReplyLibrary(@Param("newReportId") Long newReportId, @Param("size") int size);
}
