package com.bxm.localnews.news.domain;

import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.OldNewsReplyDto;
import com.bxm.localnews.news.vo.MyReceiveReplysVO;
import com.bxm.localnews.news.vo.OldMyReplysVO;
import com.bxm.localnews.news.vo.OldNewsReply;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface OldNewsReplyMapper {

    /**
     * 旧版本：插入
     * @param record
     * @return
     */
    int insertSelective(OldNewsReply record);

    /**
     * 旧版本：分页查询
     * @param newsId
     * @param page
     * @return
     */
    List<OldNewsReplyDto> queryParentList(@Param("newsId") Long newsId, @Param("page") MPage page);

    /**
     * 旧版本：根据父id查询
     * @param newsId
     * @param parentId
     * @return
     */
    List<OldNewsReply> selectReplyList(@Param("newsId") Long newsId, @Param("parentId") Long parentId);

    /**
     * 旧版本：查询用户评论
     * @param userId
     * @param page
     * @return
     */
    List<OldMyReplysVO> selectMyReplys(@Param("userId") Long userId, @Param("page") MPage page);
}
