package com.bxm.localnews.news.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.NewsReplyBaseVO;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "新闻评论实体")
public class NewsReplyDTO extends NewsReplyBaseVO {

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻id | 小视频id | 帖子id")
    private Long newsId;

    @ApiModelProperty("评论时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    @JSONField(format = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty(hidden = true)
    private Long addTimestamp;

    @ApiModelProperty("是否点赞 1：已点赞 0：未点赞")
    private Integer isLike = 0;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("类型 1:新闻 2:小视频 3:帖子")
    private Byte type;

    @ApiModelProperty("评论时间")
    private String replyTime;

    @ApiModelProperty("该评论下的回复")
    List<NewsReplyMirrorDTO> list = new ArrayList<>(10);

    @ApiModelProperty(value = "删除标记 0：未删除  1：已删除")
    private byte deleteFlag = 0;

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public byte getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(byte deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Long getAddTimestamp() {
        return this.addTimestamp;
    }

    public void setAddTimestamp(Long addTimestamp) {
        this.addTimestamp = addTimestamp;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getNewsId() {
        return this.newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public List<NewsReplyMirrorDTO> getList() {
        return list;
    }

    public void setList(List<NewsReplyMirrorDTO> list) {
        this.list = list;
    }

    public Integer getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public Integer getIsLike() {
        return isLike;
    }

    public void setIsLike(Integer isLike) {
        this.isLike = isLike;
    }

    public String getReplyTime() {
        return replyTime;
    }

    public void setReplyTime(String replyTime) {
        this.replyTime = replyTime;
    }
}
