package com.bxm.localnews.news.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.localnews.news.vo.NewsReplyBaseVO;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(description = "新闻评论详细信息")
public class NewsReplyDetailDTO extends NewsReplyBaseVO {

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻ID")
    private Long newsId;

    @ApiModelProperty("评论时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    @JSONField(format = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty(hidden = true)
    private Long addTimestamp;

    @ApiModelProperty("是否点赞 1：已点赞 0：未点赞")
    private Integer isLike = 0;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("该评论下的回复")
    List<NewsReplyMirrorDTO> list = new ArrayList<>(10);

    @ApiModelProperty("新闻链接")
    private String linkUrl;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("类型：1.新闻  2.小视频")
    private Byte type;

    @ApiModelProperty("删除标记 0：未删除  1：已删除")
    private byte deleteFlag = 0;

    @ApiModelProperty("评论时间")
    private String replyTime;

    @ApiModelProperty("小视频回复详细实体")
    private ReplyVideoDTO replyVideoDto;

    @ApiModelProperty("新闻回复详细实体")
    private ReplyNewsDTO replyNewsDto;

    @ApiModelProperty("帖子回复详细实体")
    private ReplyPostDTO replyPostDto;

    public ReplyPostDTO getReplyPostDto() {
        return replyPostDto;
    }

    public void setReplyPostDto(ReplyPostDTO replyPostDto) {
        this.replyPostDto = replyPostDto;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public ReplyNewsDTO getReplyNewsDto() {
        return replyNewsDto;
    }

    public void setReplyNewsDto(ReplyNewsDTO replyNewsDto) {
        this.replyNewsDto = replyNewsDto;
    }

    public ReplyVideoDTO getReplyVideoDto() {
        return replyVideoDto;
    }

    public void setReplyVideoDto(ReplyVideoDTO replyVideoDto) {
        this.replyVideoDto = replyVideoDto;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getNewsId() {
        return newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Long getAddTimestamp() {
        return addTimestamp;
    }

    public void setAddTimestamp(Long addTimestamp) {
        this.addTimestamp = addTimestamp;
    }

    public Integer getIsLike() {
        return isLike;
    }

    public void setIsLike(Integer isLike) {
        this.isLike = isLike;
    }

    public Integer getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public List<NewsReplyMirrorDTO> getList() {
        return list;
    }

    public void setList(List<NewsReplyMirrorDTO> list) {
        this.list = list;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public byte getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(byte deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public String getReplyTime() {
        return replyTime;
    }

    public void setReplyTime(String replyTime) {
        this.replyTime = replyTime;
    }
}
