package com.bxm.localnews.news.param;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseParam;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "【新版】新闻推荐参数")
public class HomeRecommendParam extends PageParam {

    @ApiModelProperty(value = "频道ID,[身边事]栏目默认传36", required = true)
    private Long kindId;

    @ApiModelProperty(value = "是否热门频道,根据配置的频道ID来判断", hidden = true)
    private Integer isHot;

    @ApiModelProperty(value = "推荐方式，1：下拉刷新，2：上拉刷新，首次进入为下拉刷新", required = true)
    private Integer recommendType;

    @ApiModelProperty(value = "当前请求的用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "当前用户的所属区域，用于进行地方新闻推荐", required = true)
    private String areaCode;

    @ApiModelProperty("当前是第几次请求（相当于页数，作用等同于pageNum，两个参数意义一样，历史遗留问题），用于控制广告、小视频的插入")
    private Integer curPage = 0;

    public Integer getCurPage() {
        return curPage;
    }

    public void setCurPage(Integer curPage) {
        this.curPage = curPage;
    }

    public Long getKindId() {
        return kindId;
    }

    public void setKindId(Long kindId) {
        this.kindId = kindId;
    }

    public Integer getIsHot() {
        return isHot;
    }

    public void setIsHot(Integer isHot) {
        this.isHot = isHot;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getRecommendType() {
        return recommendType;
    }

    public void setRecommendType(Integer recommendType) {
        this.recommendType = recommendType;
    }
}
