package com.bxm.localnews.news.param;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhaoyadong 2018/11/9 11:26
 * @desc
 */
@ApiModel(description = "获取用户评论时时传入的参数")
public class UserReplyParam extends PageParam implements IUserIdSharding {

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("当前页码")
    private Integer curPage = 0;

    @ApiModelProperty("地区编码")
    private String areaCode;



    public Integer getCurPage() {
        return curPage;
    }

    public void setCurPage(Integer curPage) {
        this.curPage = curPage;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }
}
