package com.bxm.localnews.news.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

@ApiModel(description = "版块")
public class ForumVo {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("描述")
    private String descp;

    @ApiModelProperty("图标")
    private String icon;

    @ApiModelProperty("参与人数")
    private Long participantsNum;

    @ApiModelProperty("小程序分享路由")
    private String appletShareUrl;

    @ApiModelProperty("h5分享链接")
    private String shareUrl;

    @ApiModelProperty("内容")
    private String content;

    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public String getAppletShareUrl() {
        return appletShareUrl;
    }

    public void setAppletShareUrl(String appletShareUrl) {
        this.appletShareUrl = appletShareUrl;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescp() {
        return descp;
    }

    public void setDescp(String descp) {
        this.descp = descp;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Long getParticipantsNum() {
        return participantsNum;
    }

    public void setParticipantsNum(Long participantsNum) {
        this.participantsNum = participantsNum;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ForumVo forumVo = (ForumVo) o;
        return id.equals(forumVo.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
