package com.bxm.localnews.news.vo;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * t_mixed_recommend_pool
 * @author 
 */
public class MixedRecommendPool implements Serializable {
    /**
     * 新闻或帖子id
     */
    private Long id;

    /**
     * 新闻或帖子标题
     */
    private String title;

    /**
     * 新闻或帖子投放地区
     */
    private String areaDetail;

    /**
     * 权重
     */
    private Integer weight;

    /**
     * 来源 1：社区帖子 2：本地新闻 3：全国新闻
     */
    private String origin;

    /**
     * 展示时间
     */
    private Date issueTime;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 修改时间
     */
    private Date modifyTime;


    /**
     * 状态 0：失效 1：可用   
     */
    private Byte status;

    /**
     * 优化通知 0不发送, 1等待发送, 2已发送
     */
    private Byte optimizationNotice;

    /**
     * 定时推荐时间
     */
    private Date recommendTime;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAreaDetail() {
        return areaDetail;
    }

    public void setAreaDetail(String areaDetail) {
        this.areaDetail = areaDetail;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public Date getIssueTime() {
        return issueTime;
    }

    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Byte getOptimizationNotice() {
        return optimizationNotice;
    }

    public void setOptimizationNotice(Byte optimizationNotice) {
        this.optimizationNotice = optimizationNotice;
    }

    public Date getRecommendTime() {
        return recommendTime;
    }

    public void setRecommendTime(Date recommendTime) {
        this.recommendTime = recommendTime;
    }
}