package com.bxm.localnews.news.vo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "新闻监控任务构建参数")
@Data
public class MonitorTaskBuildParam extends BaseBean {
    @ApiModelProperty("新闻监控任务ID")
    private Long monitorId;

    @ApiModelProperty("新闻监控指标ID")
    private Long indexId;

    @ApiModelProperty("监控指标名称")
    private String name;

    @ApiModelProperty("触发时间，单位：小时，取值为[0-23]")
    private String fireTime;

    @ApiModelProperty("新闻类目")
    private Integer kindId;

    @ApiModelProperty("监控区域")
    private String areaCodes;

    @ApiModelProperty("新闻监控数量")
    private Integer num;

    @ApiModelProperty(value = "监控的具体区域", hidden = true)
    private String areaCode;

    @ApiModelProperty(value = "监控的开始时间", hidden = true)
    private String startTime;

    @ApiModelProperty(value = "监控的截止时间", hidden = true)
    private String endTime;

    public Long getMonitorId() {
        return monitorId;
    }

    public MonitorTaskBuildParam setMonitorId(Long monitorId) {
        this.monitorId = monitorId;
        return this;
    }

    public Long getIndexId() {
        return indexId;
    }

    public MonitorTaskBuildParam setIndexId(Long indexId) {
        this.indexId = indexId;
        return this;
    }

    public String getName() {
        return name;
    }

    public MonitorTaskBuildParam setName(String name) {
        this.name = name;
        return this;
    }

    public String getFireTime() {
        return fireTime;
    }

    public MonitorTaskBuildParam setFireTime(String fireTime) {
        this.fireTime = fireTime;
        return this;
    }

    public Integer getKindId() {
        return kindId;
    }

    public MonitorTaskBuildParam setKindId(Integer kindId) {
        this.kindId = kindId;
        return this;
    }

    public String getAreaCodes() {
        return areaCodes;
    }

    public MonitorTaskBuildParam setAreaCodes(String areaCodes) {
        this.areaCodes = areaCodes;
        return this;
    }

    public Integer getNum() {
        return num;
    }

    public MonitorTaskBuildParam setNum(Integer num) {
        this.num = num;
        return this;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public MonitorTaskBuildParam setAreaCode(String areaCode) {
        this.areaCode = areaCode;
        return this;
    }

    public String getStartTime() {
        return startTime;
    }

    public MonitorTaskBuildParam setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String getEndTime() {
        return endTime;
    }

    public MonitorTaskBuildParam setEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }
}
